#include <stdlib.h>
#include <stdio.h>
#include <math.h>  /* NEEDED FOR MATH MACROS. REMOVE, IF DEFINED ELSEWHERE */

#include <solvopt.h>  /* initializes solvopt_options and declares null_entry */
double const a[5][10]=
   {0.0, 2.0, 1.0, 1.0, 3.0, 0.0, 1.0, 1.0, 0.0, 1.0,
    0.0, 1.0, 2.0, 4.0, 2.0, 2.0, 1.0, 0.0, 0.0, 1.0,
    0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0,
    0.0, 1.0, 1.0, 2.0, 0.0, 0.0, 1.0, 2.0, 1.0, 0.0,
    0.0, 3.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0};
double const b[10]={
    1.0, 5.0, 10.0, 2.0, 4.0, 3.0, 1.7, 2.5, 6.0, 4.5};
unsigned short i,j;

void main ()
{
  double x[5]={-1.0,1.0,-1.0,1.0,-1.0}, f;
  double far shorf(), solvopt();
  void far shorg();
  unsigned short n=5, i;
  unsigned short user_supplied_gradients=1;  
                                /*1 for user-supplied gradients
                                  0 for gradient approximation */
    
  if (user_supplied_gradients)
  f=solvopt(n,x,&shorf,&shorg,solvopt_options,&null_entry,&null_entry);
  else
  f=solvopt(n,x,&shorf,&null_entry,solvopt_options,&null_entry,&null_entry);

  printf("\n\n  Function Value =====  Evaluations  === Iterations\n"
         "%16.9g       %6.0f+%5.0f       %5.0f",
         f,solvopt_options[9],solvopt_options[10],solvopt_options[8]);
  printf("\n\n Optimum Point X:");
  for (i=0;i<n;i++)
  printf("\n %16.9g", x[i]);
}
double shorf(double x[])
/* Function SHORF returns the function value at a point
   for Shor's piece-wise quadratic function */
{  double f,d,s; 
   f=0.0;  for (i=0;i<10;i++)
           {  s=0.0;  for (j=0;j<5;j++) s+=(x[j]-a[j][i])*(x[j]-a[j][i]); 
              d=b[i]*s;  if (d>f) f=d;
           }
   return (f);
}
void shorg(double x[], double g[])
/* Function SHORG returns the gradient vector 
  of Shor's piece-wise quadratic function at a point */
{  double f,d,s; unsigned short k;
   f=0.0;  for (i=0;i<10;i++)
    {   s=0.0;  for (j=0;j<5;j++)  s+=(x[j]-a[j][i])*(x[j]-a[j][i]); 
        d=b[i]*s;  if (d>f) { f=d; k=i; }
    }
    for (j=0;j<5;j++)  g[j]=b[k]*0.5*(x[j]-a[j][k]);
}
