#include <stdlib.h>
#include <stdio.h>
#include <math.h>  /* NEEDED FOR MATH MACROS. REMOVE, IF DEFINED ELSEWHERE */

#include <solvopt.h>  /* initializes solvopt_options and declares null_entry */

void main ()
{
  double x[2]={-1.2,1.}, f;
  double far rosenbf(), solvopt();
  void far rosenbg(); 
  unsigned short n=2, i;
  unsigned short user_supplied_gradients=0;  
                                /*1 for user-supplied gradients
                                  0 for gradient approximation */
    
  if (user_supplied_gradients)
  f=solvopt(n,x,&rosenbf,&rosenbg,solvopt_options,&null_entry,&null_entry);
  else
  f=solvopt(n,x,&rosenbf,&null_entry,solvopt_options,&null_entry,&null_entry);

  printf("\n\n  Function Value =====  Evaluations  === Iterations\n"
         "%16.9g       %6.0f+%5.0f       %5.0f",
         f,solvopt_options[9],solvopt_options[10],solvopt_options[8]);
  printf("\n\n Optimum Point X:");
  for (i=0;i<n;i++)
  printf("\n %16.9g", x[i]);
}

double rosenbf(double x[])
{ /* ROSENBF returns the function value at a point
  for Rosenbrock's Saddle Function */
      double f;
      f=100.*pow(x[1]-x[0]*x[0],2)+pow(1.-x[0],2);
      return (f);
}
void rosenbg(double x[], double g[])
{  /* ROSENBG returns the gradient at a point
   for Rosenbrock's Saddle Function */
      g[0]=-400.*(x[1]-x[0]*x[0])*x[0]-2.*(1.-x[0]);
      g[1]= 200.*(x[1]-x[0]*x[0]);
}
