#include <stdlib.h>
#include <stdio.h>
#include <process.h>
#include <math.h>  /* NEEDED FOR MATH MACROS. REMOVE, IF DEFINED ELSEWHERE */

#include <solvopt.h>  /* initializes solvopt_options and 
                         declares void <null_entry> */

/* =========================================================*/
/* the flags indicating the way the problem is to be solved 
   ( set <user_supplied_gradients> to 0 with the aim to use 
     approximated gradients,
     set <as_constrained_problem> to 0 with the aim to use the
     pre-defined penalty coefficient <pen> ): */      
  int user_supplied_gradients=1,     as_constrained_problem=1;
/* =========================================================*/
/* the number <im> of the constraint with the maximal residual 
   (calculated in <MaxResidual> or <ObjectFunctionValue> and 
   used in <GradMaxResConstr>, resp. <ObjectFunctionGradient> ): */
  unsigned short im;
  double pen=1000.0; /* the user pre-defined penalty coefficient
                     used for minimization of a penalty function */
/* =========================================================*/
  unsigned short n=15,    /* dimension */
                 i,j,     /* counters */
                 ncnt=20; /* number of constraints */

/* problem data: */
  double const a[5][10]=
  {     -16.,   0.,-3.5,   0.,   0.,  2.,  -1., -1.,   1.,   1.,
          2.,  -2.,  0.,  -2.,  -9.,  0.,  -1., -2.,   2.,   1.,
          0.,   0.,  2.,   0.,  -2., -4.,  -1., -3.,   3.,   1.,
          1.,   .4,  0.,  -4.,   1.,  0.,  -1., -2.,   4.,   1.,
          0.,   2.,  0.,  -1.,  -2.8, 0.,  -1., -1.,   5.,   1.};
  double const b[10] = 
  { -40., -2., -.25, -4., -4., -1., -40., -60., 5., 1. };
  double const c[5][5] = 
  {  30., -20., -10.,  32., -10.,
    -20.,  39.,  -6., -31.,  32.,
    -10.,  -6.,  10.,  -6., -10.,
     32., -31.,  -6.,  39., -20.,
    -10.,  32., -10., -20.,  30. };
  double const d[5] = { 4., 8., 10., 6., 2. };
  double const e[5] = { -15., -27., -36., -18., -12. };
/* =========================================================*/
  double far solvopt();
  double ObjectFunctionValue();
  void ObjectFunctionGradient();
  double MaxResidual();
  void GradMaxResConstr(); 
  double f /* function value */;

/* Main program for solving Shell Dual Problem 
   by use of the exact penalty function method. */

void main( int argc, char *argv[] )

{ double x[15]={1.e-4,1.e-4,1.e-4,1.e-4,1.e-4,1.e-4,1.e-4,
                1.e-4,1.e-4,1.e-4,1.e-4,  60.,1.e-4,1.e-4,
                1.e-4}; /* starting point */ 
  int na, arg[2]={1,1}; 

  for(na=1;na<argc;na++) arg[na-1]=atoi(argv[na]);
  if (arg[0]==0) user_supplied_gradients=0;
  if (arg[1]==0) as_constrained_problem=0;

/*  solvopt_options[4]=1.0;  */
      
/* Call the solver: */
  if      (user_supplied_gradients && as_constrained_problem )
  f= solvopt(n,x,ObjectFunctionValue,ObjectFunctionGradient,
             solvopt_options,MaxResidual,GradMaxResConstr);
  else if (user_supplied_gradients )
  f= solvopt(n,x,ObjectFunctionValue,ObjectFunctionGradient,
             solvopt_options,null_entry,null_entry);
  else if (as_constrained_problem )
  f= solvopt(n,x,ObjectFunctionValue,null_entry,
             solvopt_options,MaxResidual,null_entry);
  else if (!user_supplied_gradients && !as_constrained_problem )
  f= solvopt(n,x,ObjectFunctionValue,null_entry,
             solvopt_options,null_entry,null_entry);

/* Display the results: */
  printf("\n\n  Function Value =====  Evaluations  === Iterations\n"
         "%16.9g       %6.0f+%5.0f       %5.0f",
         f,solvopt_options[9],solvopt_options[10],solvopt_options[8]);
   printf("\n                       %6.0f+%5.0f",
          solvopt_options[11],solvopt_options[12]);
   printf("\n\n Optimum Point X:");
   for (i=0;i<n;i++)
   printf("\n %16.9g", x[i]);

} /* end of main */  

/* Objective function */
 double ObjectFunctionValue(double x[])
 {  double fc;
    f=0.0;
    for (i=0;i<5;i++)
    {   for (j=0;j<5;j++) f+=c[i][j]*x[i]*x[j];
        f+=d[i]*pow(x[i],3)*2.0;
    }    
    for (i=5;i<15;i++)   f-=b[i-5]*x[i];
    if (as_constrained_problem) return(f);
    else   /*use pre-defined penalty coefficient*/
    {  fc=MaxResidual(x);
       if (fc>0.0)  f+=pen*fc;
       return(f);
    }   
 }   
      
/* Gradient of the objective function */
 void ObjectFunctionGradient(double x[], double g[])
 {   double s, gc[15];
     for(i=0;i<15;i++)
     {  if (i<5)
        {  g[i]=6.0*d[i]*x[i]*x[i];
           s=0.0; for (j=0;j<5;j++) s+=c[i][j]*x[j];
           g[i]+=2.0*s;
        }   
        else   g[i]=-b[i-5];
     }
     if (!as_constrained_problem) /*use pre-defined penalty coef.*/
     {  GradMaxResConstr(x,gc);
        for(i=0;i<15;i++) g[i]+=pen*gc[i];
     }   
 }    

/* The MAXIMAL RESIDIAL for the set of all constraints: */
 double MaxResidual(double x[])
 { double fc, s;
   fc=0.0; im=ncnt;
   for (i=0;i<ncnt;i++)
   {   if (i<5)
       {  s=0.0; for (j=0;j<10;j++) s+=a[i][j]*x[j+5];
                 for (j=0;j<5;j++)  s-=2.0*c[i][j]*x[j];
          s-=e[i]+3.0*d[i]*x[i]*x[i];
       } 
       else  s=-x[i-5];
       if (s>fc) { fc=s; im=i; }
   }
   return(fc);
 }  
      
/* Gradient of the constraint with the MAXIMAL RESIDIAL: */
 void GradMaxResConstr(double x[], double gc[])
 { for(j=0;j<15;j++) gc[j]=0.0;
   if (im<ncnt)
   {  if (im<5)
      {  for (j=0;j<15;j++)
         {   if (j<5) gc[j]=-2.0*c[im][j];
             else     gc[j]=a[im][j-5];
         }
         gc[im]-=6.0*d[im]*x[im];
      }
      else  gc[im-5]=-1.0;
   }
 }  
