#pragma once
#include <vector>
#include <string>
#include <cstdint>
#include <fstream>
#include <iostream>
#include <cstdint>
#include <cstring>

#include "Point2D.h"


/**
 *   @brief Generator to generate random measuring results of circle and lines in 2D
*/
class randomGenerator
{
public:
    randomGenerator();
    ~randomGenerator();

    /**
     *   @brief Generates a circle
     *
     * \param elements Created 2D-Points approximating a circle
    */
    template <class S>
    void getRandomCircleElements(std::vector<Point2D<S>> &elements);

    /**
     *   @brief Generates a line
     *
     * \param elements Created 2D-Points approximating a line
    */
    template <class S>
    void getRandomLineElements(std::vector<Point2D<S>> &elements);

    /**
     *   @brief Writes 2D-points to a file
     *      Creates a file called points.txt
     *
     * \param elements Points to write in the file.
    */
    template <class S>
    void writePointsToFile(std::vector<Point2D<S>> &elements);

    /**
     *   @brief Changes the distribution of the points along the created elements
     *
     * \param val new percentage value to qualify the distribution of the points
    */
    void setPercentDivergens(const float val)
    {
        m_percentDiv = val;
    }

    /**
     *   @brief Returns some information about the last created element
    */
    const std::string &getLastElementInformation()
    {
        return m_createdElement;
    }

    /**
     *   @brief sets the number of created points to a fix value!
    */
    void setNumOfPoints(const int val)
    {
        m_numOfPoints = val;
        m_useFixNumOfPoints = true;
    }

    /**
     *   @brief Resets the number of created points to a random number.
    */
    void unsetNumOfPoints()
    {
        m_useFixNumOfPoints = false;
    }

private:

    std::string m_createdElement = "No points created";
    float m_percentDiv = 0.1f;
    int m_numOfPoints = 0;
    bool m_useFixNumOfPoints = false;
};

template <class S>
void randomGenerator::getRandomCircleElements(std::vector<Point2D<S>> &elements)
{
    const int numOfElements = m_useFixNumOfPoints ? m_numOfPoints : 1000 + (rand() % 100 + 1) * 1000 + (rand() % 100 + 1) * 100 + (rand() % 100 + 1) * 10;

    elements.resize(numOfElements);

    const S radius = (1.0f + ((S)rand()) / (S)RAND_MAX) * 50;
    const Point2D<S> center(((S)rand()) / (S)RAND_MAX * 50, ((S)rand()) / (S)RAND_MAX * 50);
    for (int ii = 0; ii < numOfElements; ++ii)
    {
        const S angle = ((S)rand()) / (S)RAND_MAX * 2 * M_PI;
        const S div_x = 1.0 - ((S)rand()) / (S)RAND_MAX * m_percentDiv;
        const S div_y = 1.0 - ((S)rand()) / (S)RAND_MAX * m_percentDiv;

        elements[ii].setX(std::cos(angle) * div_x);
        elements[ii].setY(std::sin(angle) * div_y);

        elements[ii] *= radius;
        elements[ii] += center;
    }

    m_createdElement = "Circle with init parameter: \nradius: " + std::to_string(radius) + "\ncenter: " + "(" + std::to_string(center.x()) + ", " + std::to_string(center.y()) + ")";

}

template <class S>
void randomGenerator::getRandomLineElements(std::vector<Point2D<S>> &elements)
{
    const int numOfElements = m_useFixNumOfPoints ? m_numOfPoints : 1000 + (rand() % 100 + 1) * 1000 + (rand() % 100 + 1) * 100 + (rand() % 100 + 1) * 10;

    elements.resize(numOfElements);

    Point2D<S> start(((S)rand()) / (S)RAND_MAX * 50, ((S)rand()) / (S)RAND_MAX * 50);
    Point2D<S> end(((S)rand()) / (S)RAND_MAX * 50, ((S)rand()) / (S)RAND_MAX * 50);
    end += start;

    Point2D<S> direction = end - start;
    const S k = (end.y() - start.y()) / (end.x() - start.x());
    m_createdElement = "Line with init parameter: \nstart: (" + std::to_string(start.x()) + ", " + std::to_string(start.y()) + ") \nend: (" + std::to_string(end.x()) + ", " + std::to_string(end.y()) + ")   \nk: " + std::to_string(k) + ", d: " + std::to_string(end.y() - k * end.x());

    for (int ii = 0; ii < numOfElements; ++ii)
    {
        const S posFactor = ((S)rand()) / (S)RAND_MAX;

        Point2D<S> div(m_percentDiv - ((S)rand()) / (S)RAND_MAX * m_percentDiv, m_percentDiv - ((S)rand()) / (S)RAND_MAX * m_percentDiv);
        elements[ii] = start + posFactor * direction + div;
    }
}


template <class S>
void randomGenerator::writePointsToFile(std::vector<Point2D<S>> &elements)
{
    std::ofstream myfile;
    myfile.open("points.txt");
    for (const auto &point : elements)
    {
        myfile << point.x() << ", " << point.y() << "\n";
    }
    myfile.close();
}
