/**
  * @file main.cpp
  * Main program demonstrating the usage of the modul "SystemOfLinearEquations".
  * @author Rostislav Stanek
  */

#include <iostream>
#include <vector>

#include "SystemOfLinearEquations.h"

using namespace std;


int main()
{
    const vector<vector<long> > A = {{1, 2, 5, 7}, {-3, 4, 1, 8}, {0, 5, 4, 2}, {-4, -3, 1, 0}};
    vector<long> x;
    const vector<long> B = {48, 40, 30, -7};

    switch (solveSystemOfLinearEquations(A, x, B))
    {
    case 0:
    {
        cout << "Solution: ";
        for (unsigned int i = 0; i + 1 < x.size(); i++)
        {
            cout << x[i] << ", ";
        }
        cout << x.back() << endl;
        break;
    }
    case 1:
    {
        cout << "The system of linear equations has no unique solution.";
        break;
    }
    case 2:
    {
        cout << "The system of linear equations has no integer solution.";
        break;
    }
    default:
    {
        cerr << "A not specified error occured!" << endl;
        break;
    }
    }

    return 0;
}
