/**
  * @file SystemOfLinearEquations.h
  * Modul for solving a nxn integer system of linear equations.
  * @author Rostislav Stanek
  */

#pragma once

#include <stdexcept>
#include <vector>

/**
 * Solves a nxn integer system of linear equations. If the left hand side matrix is not
 * a square matrix of size at least 1x1 or if the right hand side vector has not the same
 * size as the left hand side matrix, the function throws a range_error.
 * @param[in] A Left hand side matrix.
 * @param[out] x Solution vector.
 * @param[in] B Right hand sidevector.
 * @return[out]
 *   <ul>
 *     <li>0 The function succeeded.</li>
 *     <li>1 The system of linear equations has no unique solution.</li>
 *     <li>2 The system of linear equations has no integer solution.</li>
 *   </ul>
 */
int solveSystemOfLinearEquations(
    const std::vector<std::vector<long> > &A,
    std::vector<long> &x,
    const std::vector<long> &B);
