/**
  * @file SystemOfLinearEquations.cpp
  * Modul for solving a nxn integer system of linear equations.
  * @author Rostislav Stanek
  */

#include <iostream>

#include "SystemOfLinearEquations.h"


/**
 * Computes the determinante of a square nxn matrix. If the matrix is not a square matrix of
 * size at least 1x1, the function throws a range_error.
 * @param[in] A Matrix.
 * @return[out] Determinante.
 */
long determinante(const std::vector<std::vector<long> > &A);
long determinante(const std::vector<std::vector<long> > &A)
{
    if (A.empty())
    {
        throw std::range_error("A square matrix of size at least 1x1 is requaired!");
    }
    const unsigned int n = A.size();
    for (const std::vector<long> &a : A)
    {
        if (a.size() != n)
        {
            throw std::range_error("A square matrix of size at least 1x1 is requaired!");
        }
    }

    long result = 0;
    switch (n)
    {
    case 1:
    {
        result = A[0][0];
        break;
    }
    case 2:
    {
        result = A[0][0] * A[1][1] - A[1][0] * A[0][1];
        break;
    }
    case 3:
    {
        result =
            A[0][0] * A[1][1] * A[2][2] +
            A[0][1] * A[1][2] * A[2][0] +
            A[0][2] * A[1][0] * A[2][1] -
            A[2][0] * A[1][1] * A[0][2] -
            A[2][1] * A[1][2] * A[0][0] -
            A[2][2] * A[1][0] * A[0][1];
        break;
    }
    default:
    {
        for (unsigned int i = 0; i < n; i++)
        {
            std::vector<std::vector<long> > matrixMinor;
            for (unsigned int j = 0; j < n; j++)
            {
                if (j != i)
                {
                    matrixMinor.push_back(std::vector<long>(A[j].begin() + 1, A[j].end()));
                }
            }
            if (i % 2 == 0)
            {
                result += A[i][0] * determinante(matrixMinor);
            }
            else
            {
                result -= A[i][0] * determinante(matrixMinor);
            }
        }
        break;
    }
    }

    return result;
}

int solveSystemOfLinearEquations(
    const std::vector<std::vector<long> > &A,
    std::vector<long> &x,
    const std::vector<long> &B)
{
    if (A.empty())
    {
        throw std::range_error("A square matrix of size at least 1x1 is requaired!");
    }
    const unsigned int n = A.size();
    for (const std::vector<long> &a : A)
    {
        if (a.size() != n)
        {
            throw std::range_error("A square matrix of size at least 1x1 is requaired!");
        }
    }
    if (B.size() != n)
    {
        throw std::range_error(
            "The right hand side vector has to have the same size as the left hand size matrix!");
    }

    int result = 0;
    x.resize(n);
    const long determinanteA = determinante(A);
    if (determinanteA == 0)
    {
        result = 1;
    }
    else
    {
        for (unsigned int i = 0; i < n; i++)
        {
            if (result == 0)
            {
                std::vector<std::vector<long> > aX;
                for (unsigned int j = 0; j < n; j++)
                {
                    std::vector<long> aXRow;
                    aXRow.insert(aXRow.end(), A[j].begin(), A[j].begin() + i);
                    aXRow.push_back(B[j]);
                    aXRow.insert(aXRow.end(), A[j].begin() + i + 1, A[j].end());
                    aX.push_back(aXRow);
                }
                const long determinanteAX = determinante(aX);
                if (determinanteAX % determinanteA == 0)
                {
                    x[i] = determinanteAX / determinanteA;
                }
                else
                {
                    result = 2;
                }
            }
        }
    }

    return result;
}

